using System;
using System.Runtime.InteropServices;

namespace Cioina
{
	/// <summary>
	/// Copyright  2003 by Cioina Alexei <cioina@usm.md, cioina@hotmail.com>. All rights reserved.
	/// </summary>
	
	public delegate double TUserFunction( int ParamCount );

	public class CioinaEval
	{
		public const int EX_NONMATH=0;
		public const int EX_Overflow=1;
		public const int EX_Underflow=2;
		public const int EX_InvalidArgument=3;
		public const int EX_ZeroDivide=4;
		public const int EX_InvalidOp=5;

		public const int ERR_NOERROR=0;
		public const int ERR_NO_MATH_EXPRESSION_WAS_PARSED=-1;
		public const int ERR_PARANTHESES_SYNTAX_ERROR=-2;
		public const int ERR_INVALID_DERIVATIVE_VARIABLE_NAME=-3;
		public const int ERR_MATH_EXPRESSION_IS_EMPTY=-4;
		public const int ERR_IDENTIFIER_CANNOT_BE_EMPTY=-5;
		public const int ERR_IDENTIFIER_LENGTH=-6;
		public const int ERR_NOT_PASCAL_IDENTIFIER=-7;
		public const int ERR_IDENTIFIER_CANNOT_BE_RESERVED_NAME=-8;
		public const int ERR_IDENTIFIER_ALREADY_EXISTS=-9;
		public const int ERR_DUBLICATING_USER_IDENTIFIER=-10;
		public const int ERR_UNKNOWN_EXPRESSION=-11;
		public const int ERR_BAD_EXPONENTIAL_FORMAT=-12;
		public const int ERR_SET_OriginalMathExpressionString_FALSE=-13;
		public const int ERR_MATH_EXPRESSION_WAS_ERASED=-14;
		public const int ERR_USE_VerifySyntaxSemanticsAndDerivation=-15;
		public const int ERR_DERIVATIVE_EXPRESSION_WAS_ERASED=-16;
		public const int ERR_VARIABLES_AND_VALUES_ARE_DIFFERENT=-17;
		public const int ERR_MATH_EXPRESSIONS_ARRAY=-18;
		public const int ERR_FUNCTION_NUMBER_MUST_BE_LESS=-19;
		public const int ERR_FUNCTION_ADDRESS_CANNOT_BE_NIL=-20;
		public const int ERR_PROTECTED_EXPRESSION=-21;
		public const int ERR_PARSE=-22;
		public const int ERR_EXECUTE=-23;
		public const int ERR_DYNAMIC_MEMORY=-24;
		public const int ERR_MULTIPLY=-25;
		public const int ERR_DIVISION=-26;
		public const int ERR_PLUS=-27;
		public const int ERR_MINUS=-28;
		public const int ERR_POWER=-29;
		public const int ERR_EQUAL=-30;
		public const int ERR_UNKNOWN_FUNCTION=-31;
	    public const int ERR_UNKNOWN_VARIABLE=-32;
		public const int ERR_BAD_SYNTAX=-33;
		public const int ERR_COMMA_SYNTAX=-34;
		public const int ERR_SYSTEM_STACK_OVERFLOW=-35;
		public const int ERR_DEF_FUNC_NAME=-36;
		public const int ERR_DEF_FUNC_DUBLICATING=-37;
		public const int ERR_DEF_FUNC_IMPLEMENTING=-38;
		public const int ERR_DEF_FUNC_ARG_COUNT=-39;
		public const int ERR_DEF_FUNC_ARG_NAME=-40;
		public const int ERR_DEF_FUNC_ARG_DUBLICATING=-41;
		public const int ERR_DEF_FUNCTION_STACK_OVERFLOW=-42;

		public const int MaxParamCount = 2147483647;
		const string CioinaDllPath="Cioina";
		//const string CioinaDllPath="E:\\Cioina\\Temp\\tmp2\\Calc\\Cioina";
		
		[DllImport(CioinaDllPath)]public static extern void CreateList();
		[DllImport(CioinaDllPath)]public static extern void ClearList();
		[DllImport(CioinaDllPath)]public static extern void ClearSharedVariables();
		[DllImport(CioinaDllPath)]public static extern void ClearUserFunctions();
		[DllImport(CioinaDllPath)]public static extern void FreeAll();
		[DllImport(CioinaDllPath)]public static extern void AddMathExpression();
		[DllImport(CioinaDllPath)]public static extern void AddMathExpressionWithUserFunctions();
		[DllImport(CioinaDllPath)]public static extern void AddSharedVar( string  VarName, double DefValue, ushort Protect );
		[DllImport(CioinaDllPath)]public static extern void AddUserFunction( string  FuncName, TUserFunction FuncAddress, int ParamCount);
		[DllImport(CioinaDllPath)]public static extern void ClearMathExpression( int id );
		[DllImport(CioinaDllPath)]public static extern void DeleteParantheses( int id, ref string  res );
		[DllImport(CioinaDllPath)]public static extern void ExpressionReplace( int id, ref string  res,  string  OldPattern,  string  NewPattern );
		[DllImport(CioinaDllPath)]public static extern void Parse( int id,  string  MathStr,  string  VarStr, ushort CheckUnknownVar );
		[DllImport(CioinaDllPath)]public static extern void ParseAndDifferentiate( int id,  string  MathStr,  string  VarStr,  string  DerStr, ushort CheckUnknownVar );
		[DllImport(CioinaDllPath)]public static extern void ParseAndDifferentiateWithSharedVar( int id,  string  MathStr,  string  DerStr, ushort CheckUnknownVar );
		[DllImport(CioinaDllPath)]public static extern void ParseWithSharedVar( int id,  string  MathStr, ushort CheckUnknownVar );
		[DllImport(CioinaDllPath)]public static extern double DoMathExpression( int id );
		[DllImport(CioinaDllPath)]public static extern void DoVectorOfMathExpressions( int id );
		[DllImport(CioinaDllPath)]public static extern int GetListCount();
		[DllImport(CioinaDllPath)]public static extern ushort GetErrorFlag( int id );
		[DllImport(CioinaDllPath)]public static extern ushort GetIsMathExpressionVariable( int id );
		[DllImport(CioinaDllPath)]public static extern ushort GetIsMathExpressionPublic( int id );
		[DllImport(CioinaDllPath)]public static extern ushort GetIsMathExpressionProtected( int id );
		[DllImport(CioinaDllPath)]public static extern ushort GetIsMathExpressionLinear( int id );
		[DllImport(CioinaDllPath)]public static extern void GetErrorMessageInfo( int id, ref string res );
		[DllImport(CioinaDllPath)]public static extern int GetErrorNumber( int id );
		[DllImport(CioinaDllPath)]public static extern double GetSharedVar( int i );
		[DllImport(CioinaDllPath)]public static extern int GetSharedVarCount();
		[DllImport(CioinaDllPath)]public static extern int GetVariableCount( int id );
		[DllImport(CioinaDllPath)]public static extern int GetVariableLowIndex( int id );
		[DllImport(CioinaDllPath)]public static extern void GetVariableName( int id, int i, ref string res );
		[DllImport(CioinaDllPath)]public static extern double GetVariableValue( int id, int i );
		[DllImport(CioinaDllPath)]public static extern ushort IsValidIdentName( int id,  string  s );
		[DllImport(CioinaDllPath)]public static extern void ClearDerivativeExpressionString( int id );
		[DllImport(CioinaDllPath)]public static extern void ClearMathExpressionString( int id );
		[DllImport(CioinaDllPath)]public static extern void SetSharedVar( int i, double Value );
		[DllImport(CioinaDllPath)]public static extern void SetVariableValue( int id, int i, double Value );
		[DllImport(CioinaDllPath)]public static extern void GetMathematicaFormVariableNames( int id, ref string res );
		[DllImport(CioinaDllPath)]public static extern int GetMathExpressionCount( int id );
		[DllImport(CioinaDllPath)]public static extern void GetMathExpressionString( int id, ref string res );
		[DllImport(CioinaDllPath)]public static extern int GetMaxIterations( int id );
		[DllImport(CioinaDllPath)]public static extern ushort GetProtectVariablesEndedWithNumber( int id );
		[DllImport(CioinaDllPath)]public static extern ushort GetProtectVariablesEndedWithoutNumber( int id );
		[DllImport(CioinaDllPath)]public static extern int GetValuesVectorCount();
		[DllImport(CioinaDllPath)]public static extern double GetValuesVector( int i );
		[DllImport(CioinaDllPath)]public static extern void SetProtectVariablesEndedWithNumber( int id, ushort Value );
		[DllImport(CioinaDllPath)]public static extern void SetProtectVariablesEndedWithoutNumber( int id, ushort Value );
		[DllImport(CioinaDllPath)]public static extern int GetMaxStack( int id );
		[DllImport(CioinaDllPath)]public static extern ushort GetSpaceLikeMultiply( int id );
		[DllImport(CioinaDllPath)]public static extern int GetTotalFunctionCount( int id );
		[DllImport(CioinaDllPath)]public static extern void SetMaxIterations( int id, int Value );
		[DllImport(CioinaDllPath)]public static extern void SetMaxStack( int id, int Value );
		[DllImport(CioinaDllPath)]public static extern void SetSpaceLikeMultiply( int id, ushort Value );
		[DllImport(CioinaDllPath)]public static extern void GetDerivativeExpressionString( int id, ref string res );
		[DllImport(CioinaDllPath)]public static extern void GetDerivativeVariableString( int id, ref string res );
		[DllImport(CioinaDllPath)]public static extern void GetMathematicaFormDerivativeExpressionString( int id, ref string res );
		[DllImport(CioinaDllPath)]public static extern void GetMathematicaFormMathExpressionString( int id, ref string res );
		[DllImport(CioinaDllPath)]public static extern int GetMathException( int id );
		[DllImport(CioinaDllPath)]public static extern ushort GetPowerOperator( int id );
		[DllImport(CioinaDllPath)]public static extern void SetPowerOperator( int id, ushort Value );
		[DllImport(CioinaDllPath)]public static extern int GetAllocDynamicMemoryInfo( int id );
		[DllImport(CioinaDllPath)]public static extern int GetRunTimeFunctionCount( int id );
		[DllImport(CioinaDllPath)]public static extern void GetBuiltInFunctionInfo( int id, int i, ref string res );
		[DllImport(CioinaDllPath)]public static extern int GetBuiltInFunctionCount();
		[DllImport(CioinaDllPath)]public static extern void GetBuiltInFunctionName( int i, ref string res );
		[DllImport(CioinaDllPath)]public static extern void GetRunTimeFunctionName( int id, int i, ref string res );
		[DllImport(CioinaDllPath)]public static extern void GetRunTimeFunctionDefinition( int id, int i, ref string res );
		[DllImport(CioinaDllPath)]public static extern void GetExceptionInfo( int id, int i, ref string res );
		[DllImport(CioinaDllPath)]public static extern ushort GetOriginalMathExpressionString( int id );
		[DllImport(CioinaDllPath)]public static extern void GetOwnerInfo( ref string res );
		[DllImport(CioinaDllPath)]public static extern void GetTypeInfo( ref string res );
		[DllImport(CioinaDllPath)]public static extern void GetVersionInfo( ref string res );
		[DllImport(CioinaDllPath)]public static extern void GetDedicationInfo( ref string res );
		[DllImport(CioinaDllPath)]public static extern void SetOriginalMathExpressionString( int id, ushort Value );
		[DllImport(CioinaDllPath)]public static extern void GetLastErrorMessage( ref string res );
		[DllImport(CioinaDllPath)]public static extern void SetLastErrorMessage( string s );
		[DllImport(CioinaDllPath)]public static extern ushort GetLastErrorFlag();
		[DllImport(CioinaDllPath)]public static extern void SetLastErrorFlag( ushort flg );
		[DllImport(CioinaDllPath)]public static extern int GetLastErrorNumber();
		[DllImport(CioinaDllPath)]public static extern void SetLastErrorNumber( int i );
		[DllImport(CioinaDllPath)]public static extern double Prm( int i );
		[DllImport(CioinaDllPath)]public static extern ushort GetFPU8087CW();
		[DllImport(CioinaDllPath)]public static extern void SetFPU8087CW( ushort i );

	}
}
